import pandas as pd
import numpy as np
import pickle

atp_tennis = pd.read_csv('atp_tennis.csv')

# Define ranking groups based on average rank   
unique_player_data['Rank_Group'] = pd.cut(unique_player_data['Avg_Rank'], bins=[0, 50, 200, np.inf], labels=['Top-ranked', 'Mid-ranked', 'Low-ranked'])   

# Calculate the average win/loss ratio for each ranking group and surface type   
grouped_data = player_data.merge(unique_player_data[['Player', 'Rank_Group']], on='Player')   
grouped_data = grouped_data.groupby(['Rank_Group', 'Surface']).agg({'Win_Loss_Ratio': 'mean'}).reset_index() 

print(grouped_data)
pickle.dump(grouped_data,open("./ref_result/grouped_data.pkl","wb"))